package com.jiejing.fitness.finance.api.cashier;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.cashier.request.BindStudioCashierRequest;
import com.jiejing.fitness.finance.api.cashier.request.GetStudioCashierByIdRequest;
import com.jiejing.fitness.finance.api.cashier.request.ListStudioCashierByOrderNoRequest;
import com.jiejing.fitness.finance.api.cashier.request.ListStudioCashierBySubOrderNoRequest;
import com.jiejing.fitness.finance.api.cashier.request.PageStudioCashierRequest;
import com.jiejing.fitness.finance.api.cashier.request.PageStudioSettleRequest;
import com.jiejing.fitness.finance.api.cashier.request.UnbindStudioCashierRequest;
import com.jiejing.fitness.finance.api.cashier.vo.StudioCashierRecordVO;
import com.jiejing.fitness.finance.api.cashier.vo.StudioCashierStatisticVO;
import com.jiejing.fitness.finance.api.cashier.vo.StudioSettleVO;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author chengyubing
 * @since 2024/2/29 10:41
 */
@FeignClient(name = "FINANCE", url = "${rpc.url.fit-finance:http://app-fit-finance:7008}", fallbackFactory = StudioCashierApiFallback.class)
public interface StudioCashierApi {

  String TAG = "【场馆】收银管理";

  @ApiOperation(value = "绑定流水", tags = {TAG})
  @PostMapping(value = "/private/studioCashier/bind")
  JsonResult<Void> bind(BindStudioCashierRequest request);

  @ApiOperation(value = "解绑流水", tags = {TAG})
  @PostMapping(value = "/private/studioCashier/unbind")
  JsonResult<Void> unbind(UnbindStudioCashierRequest request);

  @ApiOperation(value = "分页筛选收银流水", tags = {TAG})
  @PostMapping(value = "/private/studioCashier/page")
  JsonResult<PageVO<StudioCashierRecordVO>> page(PageStudioCashierRequest request);

  @ApiOperation(value = "统计收银流水金额", tags = {TAG})
  @PostMapping(value = "/private/studioCashier/statistic")
  JsonResult<StudioCashierStatisticVO> statistic(PageStudioCashierRequest request);

  @ApiOperation(value = "查询收银流水详情", tags = {TAG})
  @PostMapping(value = "/private/studioCashier/getById")
  JsonResult<StudioCashierRecordVO> getById(GetStudioCashierByIdRequest request);

  @ApiOperation(value = "根据订单号查询收银列表", tags = {TAG})
  @PostMapping(value = "/private/studioCashier/listByOrderNo")
  JsonResult<List<StudioCashierRecordVO>> listByOrderNo(ListStudioCashierByOrderNoRequest request);

  @ApiOperation(value = "根据子订单号查询收银列表", tags = {TAG})
  @PostMapping(value = "/private/studioCashier/listBySubOrderNo")
  JsonResult<List<StudioCashierRecordVO>> listBySubOrderNo(ListStudioCashierBySubOrderNoRequest request);

  @ApiOperation(value = "分页筛选结算记录", tags = {TAG})
  @PostMapping(value = "/private/studioCashier/pageSettle")
  JsonResult<PageVO<StudioSettleVO>> pageSettle(PageStudioSettleRequest request);

}
