/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.jiejing.common.utils.collection.CollectionUtil;
import com.jiejing.common.utils.text.StringUtil;
import com.jiejing.fitness.enums.finance.ApplyTypeEnum;
import com.jiejing.fitness.finance.repository.entity.StudioMerchantApply;
import com.jiejing.fitness.finance.repository.mapper.StudioMerchantApplyMapper;
import com.jiejing.fitness.finance.repository.query.PageStudioMerchantApplyQuery;
import com.jiejing.mbp.MapperRepoService;
import com.jiejing.paycenter.common.enums.common.OpenStateEnums;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 场馆商户申请表（M端以及B端数据回显用，支付以及各状态判断、商户号不使用此表） 服务实现类
 * </p>
 *
 * @author chengyubing, created on 2024-03-05
 */
@Slf4j
@Service
public class StudioMerchantApplyRpService extends
    MapperRepoService<Long, StudioMerchantApply, StudioMerchantApplyMapper> {

  private List<String> convertApplyTypeList(List<ApplyTypeEnum> applyTypeList) {
    if (CollectionUtil.isEmpty(applyTypeList)) {
      return null;
    }
    return applyTypeList.stream().map(ApplyTypeEnum::getCode).collect(Collectors.toList());
  }

  public Page<StudioMerchantApply> page(PageStudioMerchantApplyQuery params) {
    QueryWrapper<StudioMerchantApply> wrapper = new QueryWrapper<>();
    if (StringUtil.isNotBlank(params.getShortName())) {
      wrapper.like(StudioMerchantApply.SHORT_NAME, params.getShortName());
    }
    if (CollectionUtil.isNotEmpty(params.getApplyTypeList())) {
      wrapper.in(StudioMerchantApply.APPLY_TYPE, convertApplyTypeList(params.getApplyTypeList()));
    }
    if (null != params.getStudioId()) {
      wrapper.eq(StudioMerchantApply.STUDIO_ID, params.getStudioId());
    }
    if (null != params.getCompanyType()) {
      wrapper.eq(StudioMerchantApply.COMPANY_TYPE, params.getCompanyType().getCode());
    }
    if (StringUtil.isNotBlank(params.getMerchantName())) {
      wrapper.like(StudioMerchantApply.MERCHANT_NAME, params.getMerchantName());
    }
    if (null != params.getOpenState()) {
      wrapper.eq(StudioMerchantApply.OPEN_STATE, params.getOpenState().getCode());
    }
    if (StringUtil.isNotBlank(params.getMerchantNo())) {
      wrapper.eq(StudioMerchantApply.MERCHANT_NO, params.getMerchantNo());
    }
    if (StringUtil.isNotBlank(params.getAliMerchantNo())) {
      wrapper.eq(StudioMerchantApply.ALI_MERCHANT_NO, params.getAliMerchantNo());
    }
    if (StringUtil.isNotBlank(params.getWxOnlineMerchantNo())) {
      wrapper.eq(StudioMerchantApply.WX_ONLINE_MERCHANT_NO, params.getWxOnlineMerchantNo());
    }
    if (StringUtil.isNotBlank(params.getWxOfflineMerchantNo())) {
      wrapper.eq(StudioMerchantApply.WX_OFFLINE_MERCHANT_NO, params.getWxOfflineMerchantNo());
    }
    if (null != params.getStartTime()) {
      wrapper.ge(StudioMerchantApply.CREATE_TIME, params.getStartTime());
    }
    if (null != params.getEndTime()) {
      wrapper.le(StudioMerchantApply.CREATE_TIME, params.getEndTime());
    }
    return this.findByWrapperPage(wrapper, params.getCurrent(), params.getSize());
  }


  public StudioMerchantApply getLatestOneSuccessByMerchantId(Long merchantId) {
    return this.baseMapper.getLatestOneSuccessByMerchantId(merchantId);
  }

  public StudioMerchantApply getLatestOneSuccessByStudioId(Long studioId) {
    QueryWrapper<StudioMerchantApply> wrapper = new QueryWrapper<>();
    wrapper.eq(StudioMerchantApply.STUDIO_ID, studioId);
    return this.baseMapper.getLatestOneSuccessByStudioId(studioId);
  }

  public Integer countProcessByStudioId(Long studioId) {
    QueryWrapper<StudioMerchantApply> wrapper = new QueryWrapper<>();
    wrapper.eq(StudioMerchantApply.STUDIO_ID, studioId);
    wrapper.in(StudioMerchantApply.OPEN_STATE,
        Lists.newArrayList(OpenStateEnums.PROCESS.getCode(), OpenStateEnums.INIT.getCode()));
    wrapper.in(StudioMerchantApply.APPLY_TYPE,
        Lists.newArrayList(ApplyTypeEnum.OPEN.getCode(), ApplyTypeEnum.RE_OPEN.getCode()));
    Integer count = this.baseMapper.selectCount(wrapper);
    return Optional.ofNullable(count).orElse(0);
  }

  public List<StudioMerchantApply> listByMinId(Long minId, Long merchantId, Integer size) {
    return this.baseMapper.listByMinId(minId, merchantId, size);
  }

  public List<StudioMerchantApply> listByMerchantIds(List<Long> merchantIds) {
    QueryWrapper<StudioMerchantApply> wrapper = new QueryWrapper<>();
    wrapper.in(StudioMerchantApply.MERCHANT_ID, merchantIds);
    wrapper.eq(StudioMerchantApply.OPEN_STATE, OpenStateEnums.SUCCESS.getCode());
    wrapper.in(StudioMerchantApply.APPLY_TYPE,
        Lists.newArrayList(ApplyTypeEnum.OPEN.getCode(), ApplyTypeEnum.RE_OPEN.getCode()));
    return Optional.ofNullable(this.baseMapper.selectList(wrapper)).orElse(new ArrayList<>(1));
  }

  public Map<Long, StudioMerchantApply> mapByMerchantIds(List<Long> merchantIds) {
    List<StudioMerchantApply> applies = this.listByMerchantIds(merchantIds);
    return applies.stream().collect(Collectors.toMap(StudioMerchantApply::getMerchantId, e -> e));
  }

  public StudioMerchantApply getLatestApply(Long studioId) {
    QueryWrapper<StudioMerchantApply> wrapper = new QueryWrapper<>();
    wrapper.eq(StudioMerchantApply.STUDIO_ID, studioId);
    wrapper.orderByDesc(StudioMerchantApply.ID);
    return Optional.ofNullable(this.baseMapper.selectList(wrapper)).orElse(new ArrayList<>(1)).stream()
        .findFirst().orElse(null);
  }

}
