package com.jiejing.fitness.finance.service.bank;

import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.service.bank.dto.BankDTO;
import com.jiejing.fitness.finance.service.bank.dto.BranchBankDTO;

/**
 * @author chengyubing
 * @since 2024/4/1 14:14
 */
public interface BankService {

  /**
   * 分页筛选银行
   *
   * @param bankName 银行名称
   * @param current  页码：0开始
   * @param size     大小
   * @return 银行
   */
  PageVO<BankDTO> pageBank(String bankName, Integer current, Integer size);

  /**
   * 分页筛选银行
   *
   * @param bankCode   银行名称
   * @param branchName 支行名称
   * @param current    页码：0开始
   * @param size       大小
   * @return 银行
   */
  PageVO<BranchBankDTO> pageBranchBank(String bankCode, String branchName, Integer current, Integer size);

}
