package com.jiejing.fitness.finance.api.axf;

import com.jiejing.common.enums.ConfirmEnum;
import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.axf.request.*;
import com.jiejing.fitness.finance.api.axf.vo.*;
import com.jiejing.paycenter.common.model.vo.*;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * 安心付
 *
 * @author chengyubing
 * @since 2024/9/7 11:00
 */
@FeignClient(name = "FINANCE", url = "${rpc.url.fit-finance:http://app-fit-finance:7008}", fallbackFactory = StudioAxfOrderApiFallback.class)
public interface StudioAxfOrderApi {

  @ApiOperation(value = "取消订购单")
  @PostMapping(value = "/private/axfOrder/cancel")
  JsonResult<CancelCommodityOrderVO> cancel(CancelStudioAxfOrderRequest request);

  @ApiOperation(value = "分页查询订购单")
  @PostMapping(value = "/private/axfOrder/page")
  JsonResult<PageVO<StudioAxfOrderVO>> page(PageStudioAxfOrderRequest request);

  @ApiOperation(value = "统计订购单")
  @PostMapping(value = "/private/axfOrder/agg")
  JsonResult<AggStudioAxfOrderVO> agg(PageStudioAxfOrderRequest request);

  @ApiOperation(value = "查询订购单详情")
  @PostMapping(value = "/private/axfOrder/getById")
  JsonResult<StudioAxfOrderVO> getById(GetStudioAxfOrderRequest request);

  @ApiOperation(value = "根据订单查询安心付订购单")
  @PostMapping(value = "/private/axfOrder/getByVoucherId")
  JsonResult<StudioAxfOrderVO> getByVoucherId(GetStudioAxfOrderByVoucherIdRequest request);

  @ApiOperation(value = "查询订购单扣款明细")
  @PostMapping(value = "/private/axfOrder/listDeduction")
  JsonResult<List<StudioAxfOrderDeductionVO>> listDeduction(ListStudioAxfOrderDeductionRequest request);

  @ApiOperation(value = "校验是否存在失败的扣款")
  @PostMapping(value = "/private/axfOrder/existFailDeduction")
  JsonResult<ConfirmEnum> existFailDeduction(ListStudioAxfOrderDeductionRequest request);

  @ApiOperation(value = "查询订购单追缴明细")
  @PostMapping(value = "/private/axfOrder/listRecovery")
  JsonResult<List<StudioAxfOrderRecoveryVO>> listRecovery(ListStudioAxfOrderRecoveryRequest request);

}
