package com.jiejing.fitness.finance.api.merchant.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/22 14:03
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "品牌商户：进件资料")
public class BrandResourceInfo {

  @ApiModelProperty(value = "营业执照图片", required = true)
  @NotNull(message = "营业执照图片不能为空")
  private Long licensePicId;

  @ApiModelProperty(value = "线下经营门头照", required = true)
  @NotNull(message = "线下经营门头照不能为空")
  private Long storeHeaderPicId;

  @ApiModelProperty(value = "线下经营内景照", required = true)
  @NotNull(message = "线下经营内景照不能为空")
  private Long storeInnerPicId;

  @ApiModelProperty(value = "线下经营收银台", required = true)
  @NotNull(message = "线下经营收银台不能为空")
  private Long storeCashierDescPicId;

  @ApiModelProperty(value = "法人证件人像面（正面）", required = true)
  @NotNull(message = "法人身份证人像面不能为空")
  private Long legalCertFrontPicId;

  @ApiModelProperty(value = "法人证件国徽面（反面）", required = true)
  @NotNull(message = "法人身份证国徽面不能为空")
  private Long legalCertBackPicId;

  @ApiModelProperty(value = "银行卡正面")
  private Long bankCardFrontPicId;

  @ApiModelProperty(value = "银行卡反面")
  private Long bankCardBackPicId;

  @ApiModelProperty(value = "结算卡持卡人证件人像面（正面）")
  private Long bankCardCertFrontPicId;

  @ApiModelProperty(value = "结算卡持卡人证件国徽面(反面)")
  private Long bankCardCertBackPicId;

}
