package com.jiejing.fitness.finance.service.rpc;

import com.jiejing.common.model.JsonResult;
import com.jiejing.paycenter.api.merchant.MerchantApi;
import com.jiejing.paycenter.api.merchant.MerchantQueryApi;
import com.jiejing.paycenter.api.merchant.request.ApplyMerchantRequest;
import com.jiejing.paycenter.api.merchant.request.GetMerchantByIdRequest;
import com.jiejing.paycenter.api.merchant.request.UploadRequest;
import com.jiejing.paycenter.api.merchant.vo.ApplyMerchantResultVO;
import com.jiejing.paycenter.api.merchant.vo.MerchantVO;
import com.jiejing.paycenter.api.merchant.vo.UploadVO;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author chengyubing
 * @since 2024/2/20 16:39
 */
@Slf4j
@Service
public class MerchantRpcService {

  @Resource
  private MerchantApi merchantApi;

  @Resource
  private MerchantQueryApi merchantQueryApi;

  public String upload(UploadRequest request) {
    JsonResult<UploadVO> result = merchantApi.upload(request);
    result.assertSuccess();
    return result.getResult().getThirdId();
  }

  public ApplyMerchantResultVO apply(ApplyMerchantRequest request) {
    JsonResult<ApplyMerchantResultVO> result = merchantApi.apply(request);
    result.assertSuccess();
    return result.getResult();
  }

  public MerchantVO getByMerchantId(Long merchantId) {
    GetMerchantByIdRequest request = GetMerchantByIdRequest.builder().merchantId(merchantId).build();
    JsonResult<MerchantVO> result = merchantQueryApi.getById(request);
    result.assertSuccess();
    return result.getResult();
  }
}
