package com.jiejing.fitness.finance.api.pay;

import com.jiejing.common.model.JsonResult;
import com.jiejing.paycenter.api.pay.request.PayRequest;
import com.jiejing.paycenter.api.pay.request.SyncPayRequest;
import com.jiejing.paycenter.common.model.vo.PayVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author chengyubing
 * @since 2024/4/11 10:07
 */
@FeignClient(name = "FINANCE", url = "${rpc.url.fit-finance:http://app-fit-finance:7008}", fallbackFactory = FitPayApiFallback.class)
public interface FitPayApi {

  String TAG = "乐动支付-支付管理";

  @ApiOperation(value = "支付", tags = {TAG})
  @PostMapping(value = "/private/pay/pay")
  JsonResult<PayVO> pay(PayRequest request);

  @ApiOperation(value = "同步支付状态", tags = {TAG})
  @PostMapping(value = "/private/pay/get")
  JsonResult<PayVO> get(SyncPayRequest request);

}
