package com.jiejing.fitness.finance.app.controller.pay;

import com.jiejing.common.model.JsonResult;
import com.jiejing.fitness.finance.api.pay.FitPayApi;
import com.jiejing.paycenter.api.pay.PayApi;
import com.jiejing.paycenter.api.pay.request.PayRequest;
import com.jiejing.paycenter.api.pay.request.SyncPayRequest;
import com.jiejing.paycenter.common.model.vo.PayVO;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chengyubing
 * @since 2024/4/11 10:10
 */
@RestController
public class FitPayController implements FitPayApi {

  @Resource
  private PayApi payApi;

  @ApiOperation(value = "支付", tags = {TAG})
  @PostMapping(value = "/private/pay/pay")
  public JsonResult<PayVO> pay(@RequestBody @Valid PayRequest request) {
    return payApi.pay(request);
  }

  @ApiOperation(value = "同步支付状态", tags = {TAG})
  @PostMapping(value = "/private/pay/get")
  public JsonResult<PayVO> get(@RequestBody @Valid SyncPayRequest request) {
    return payApi.syncPay(request);
  }

}
