package com.jiejing.fitness.finance.api.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.Arrays;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author chengyubing
 * @since 2024/3/4 18:22
 */
@Getter
@AllArgsConstructor
public enum PartyTypeEnums {

  /**
   * 业务方类型
   */
  STUDIO("STUDIO", "场馆"),
  BRAND("BRAND", "品牌"),
  UNKNOWN("UNKNOWN", "未知"),
  ;

  @EnumValue
  private final String code;

  private final String desc;


  public static PartyTypeEnums getByCode(String code) {
    return Arrays.stream(PartyTypeEnums.values()).filter(e -> e.getCode().equals(code)).findFirst()
        .orElse(UNKNOWN);
  }
}
