package com.jiejing.fitness.finance.service.merchant.convert;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.jiejing.common.config.idgen.adapter.IdWorker;
import com.jiejing.common.utils.time.TimeUtil;
import com.jiejing.fitness.enums.delay.DelayTaskCodeEnum;
import com.jiejing.fitness.enums.finance.EmbededXcxEnum;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantApplyVO;
import com.jiejing.fitness.finance.repository.entity.StudioEmbeddedXcxApply;
import com.jiejing.wechat.vo.xcx.HalfScreenXcxAuthVO.AuthXcxInfo;
import com.jiejing.workflow.api.request.BatchSaveDelayTaskRequest;
import com.jiejing.workflow.api.request.BatchSaveDelayTaskRequest.TaskInfo;
import com.jiejing.workflow.common.enums.DelayTopicEnum;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author chengyubing
 * @since 2024/8/13 15:02
 */
public class StudioEmbeddedXcxConvert {

  public static StudioEmbeddedXcxApply toEntity(Long studioId, String componentAppId, String embeddedAppId,
      String appId) {
    StudioEmbeddedXcxApply record = new StudioEmbeddedXcxApply();
    record.setId(IdWorker.getId());
    record.setComponentAppId(componentAppId);
    record.setAuthorizerAppId(appId);
    record.setEmbeddedAppId(embeddedAppId);
    record.setStudioId(studioId);
    record.setState(EmbededXcxEnum.INIT.getCode());
    record.setCreateTime(new Date());
    record.setUpdateTime(new Date());
    return record;
  }

  public static StudioEmbeddedXcxApply toRefuse(Long id, String fail) {
    return StudioEmbeddedXcxApply.builder()
        .id(id)
        .state(EmbededXcxEnum.REFUSE.getCode())
        .message(fail)
        .updateTime(new Date())
        .build();
  }


  public static StudioEmbeddedXcxApply toSuccess(Long id) {
    return StudioEmbeddedXcxApply.builder()
        .id(id)
        .state(EmbededXcxEnum.SUCCESS.getCode())
        .updateTime(new Date())
        .build();
  }

  public static List<Long> filterAppIds(List<StudioEmbeddedXcxApply> applies, List<String> appIds) {
    return applies.stream()
        .filter(e -> !EmbededXcxEnum.SUCCESS.getCode().equals(e.getState()))
        .filter(e -> appIds.contains(e.getAuthorizerAppId()))
        .map(StudioEmbeddedXcxApply::getId)
        .collect(Collectors.toList());
  }

  public static List<StudioEmbeddedXcxApply> toFailList(EmbededXcxEnum status,
      List<StudioEmbeddedXcxApply> applies, List<AuthXcxInfo> authXcxInfos) {
    Map<String, AuthXcxInfo> map = authXcxInfos.stream()
        .collect(Collectors.toMap(AuthXcxInfo::getAppId, e -> e));
    return applies.stream()
        .filter(e -> null != map.get(e.getAuthorizerAppId()))
        .filter(e -> {
          AuthXcxInfo info = map.get(e.getAuthorizerAppId());
          return EmbededXcxEnum.valueOf(e.getState()) != EmbededXcxEnum.getByWxCode(
              Integer.parseInt(info.getStatus()));
        })
        .map(e -> StudioEmbeddedXcxApply.builder()
            .id(e.getId())
            .state(status.getCode())
            .updateTime(new Date())
            .build())
        .collect(Collectors.toList());
  }

  public static StudioEmbeddedXcxApply toInit(StudioEmbeddedXcxApply entity) {
    StudioEmbeddedXcxApply toInit = new StudioEmbeddedXcxApply();
    toInit.setId(entity.getId());
    toInit.setState(EmbededXcxEnum.INIT.getCode());
    toInit.setCreateTime(new Date());
    toInit.setUpdateTime(new Date());
    return toInit;
  }

  public static StudioEmbeddedXcxApply toFail(Long id, EmbededXcxEnum state) {
    StudioEmbeddedXcxApply toInit = new StudioEmbeddedXcxApply();
    toInit.setId(id);
    toInit.setState(state.getCode());
    toInit.setUpdateTime(new Date());
    return toInit;
  }

  public static BatchSaveDelayTaskRequest toDelayTask(StudioEmbeddedXcxApply apply, String appId) {
    // 同步两次即可，分别是申请后30秒，申请后5分钟。两次都没有最新状态，则认为本次申请发生异常可以人工介入
    JSONObject body = new JSONObject().fluentPut("appId", appId);
    return BatchSaveDelayTaskRequest.builder()
        .topic(DelayTopicEnum.COMMON_DELAY_TASK)
        .tenantId(apply.getStudioId())
        .bizCode(DelayTaskCodeEnum.EMBEDDED_XCX.getCode())
        .batch(Lists.newArrayList(
            TaskInfo.builder().bizId(apply.getId())
                .executionTime(TimeUtil.local().plus(apply.getCreateTime(), 30, ChronoUnit.SECONDS))
                .taskBody(body).build(),
            TaskInfo.builder().bizId(apply.getId())
                .executionTime(TimeUtil.local().plus(apply.getCreateTime(), 5, ChronoUnit.MINUTES))
                .taskBody(body).build()
        ))
        .build();
  }
}
