package com.jiejing.fitness.finance.app.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jiejing.common.model.JsonResult;
import com.jiejing.filecenter.api.authority.AuthorityApi;
import com.jiejing.filecenter.api.authority.request.GetAuthorityRequest;
import com.jiejing.filecenter.api.authority.vo.SignatureVO;
import com.jiejing.filecenter.api.common.enums.AccessTypeEnum;
import com.jiejing.filecenter.api.common.util.UploadUtil;
import com.jiejing.filecenter.api.resource.ResourceApi;
import com.jiejing.fitness.finance.service.utils.FileUtils;
import com.jiejing.paycenter.api.merchant.MerchantQueryApi;
import com.jiejing.paycenter.api.merchant.request.GetApplyMerchantRequest;
import com.jiejing.paycenter.api.merchant.vo.MerchantApplyVO;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chengyubing
 * @since 2024/2/26 10:01
 */
@RestController
public class TestController {

  @Resource
  private MerchantQueryApi merchantApi;

  @Resource
  private ResourceApi resourceApi;

  @Resource
  private AuthorityApi authorityApi;


  @PostMapping(value = "/private/test/getApply")
  public JsonResult<MerchantApplyVO> getApply(@RequestBody @Valid GetApplyMerchantRequest request) {
    return merchantApi.getApply(request);
  }

  @PostMapping(value = "/private/test/upload")
  public JsonResult<SignatureVO> upload(@RequestParam String url) throws IOException {
    GetAuthorityRequest request = new GetAuthorityRequest();
    request.setAccessTypeEnum(AccessTypeEnum.PRIVATE);
    request.setBizCode("FINANCE_INFO");
    request.setTenantId(1L);
    request.setTenantType("BRAND");
    request.setResourceName(IdWorker.getIdStr() + getSuffix(url));
    Map<String, String> params = new HashMap<>(1);
    params.put("tenantId", "1");
    request.setParamMap(params);
    JsonResult<SignatureVO> result = authorityApi.getAuthoritySignatureForInner(request);
    result.assertSuccess();
    SignatureVO signatureVO = result.getResult();
    UploadUtil.uploadFile(FileUtils.getInputStream(url), request.getResourceName(), signatureVO, 1000000);
    return result;
  }

  private String getSuffix(String url) {
    String[] split = url.split("\\?");
    String fileName = StringUtils.substringAfterLast(split[0], "/");
    String[] names = fileName.split("\\.");
    return "." + names[names.length - 1];
  }

}
