package com.jiejing.fitness.finance.service.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * @author chengyubing
 * @since 2024/2/27 14:16
 */
public class FeeUtil {

  /**
   * 计算支付手续费，保留小数点后两位，四舍五入
   *
   * @param feeRate 费率（%）
   * @param amount  支付金额
   * @return 手续费
   */
  public static BigDecimal calPayFee(BigDecimal feeRate, BigDecimal amount) {
    return MoneyUtil.defaultRound(MoneyUtil.multiply(
        MoneyUtil.divide(feeRate, new BigDecimal("100"), 4, RoundingMode.HALF_UP.ordinal()),
        amount));
  }

}
