package com.jiejing.fitness.finance.api.axf;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.common.request.IdRequest;
import com.jiejing.fitness.finance.api.axf.request.AxfAuthTokenRequest;
import com.jiejing.fitness.finance.api.axf.request.BindAxfSettleAccountRequest;
import com.jiejing.fitness.finance.api.axf.request.GetAxfAuthTokenRequest;
import com.jiejing.fitness.finance.api.axf.request.GetLatestAxfApplyRequest;
import com.jiejing.fitness.finance.api.axf.request.StudioAxfApplyRequest;
import com.jiejing.fitness.finance.api.axf.request.ListAxfSettleAccountRequest;
import com.jiejing.fitness.finance.api.axf.request.PageStudioAxfApplyRequest;
import com.jiejing.fitness.finance.api.axf.vo.AggStudioAxfApplyVO;
import com.jiejing.fitness.finance.api.axf.vo.StudioAuthTokenVO;
import com.jiejing.fitness.finance.api.axf.vo.StudioAxfApplyVO;
import com.jiejing.fitness.request.StudioIdRequest;
import com.jiejing.paycenter.common.model.vo.BindCardVO;
import feign.hystrix.FallbackFactory;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 安心付
 *
 * @author chengyubing
 * @since 2024/9/7 11:00
 */
@Slf4j
@Component
public class StudioAxfApiFallback implements FallbackFactory<StudioAxfApi> {

  @Override
  public StudioAxfApi create(Throwable throwable) {
    return new StudioAxfApi() {
      @Override
      public JsonResult<StudioAuthTokenVO> authToken(AxfAuthTokenRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<StudioAuthTokenVO> getAuthToken(GetAxfAuthTokenRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<Long> apply(StudioAxfApplyRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<List<String>> listSettleAccount(ListAxfSettleAccountRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<BindCardVO> bindCard(BindAxfSettleAccountRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<StudioAxfApplyVO> getLatestApply(GetLatestAxfApplyRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<StudioAxfApplyVO> getById(IdRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<StudioAxfApplyVO> getMerchant(StudioIdRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<PageVO<StudioAxfApplyVO>> page(PageStudioAxfApplyRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<AggStudioAxfApplyVO> agg() {
        return JsonResult.rpcError();
      }
    };
  }
}
