package com.jiejing.fitness.finance.api.axf;

import com.jiejing.common.model.JsonResult;
import com.jiejing.fitness.finance.api.axf.request.CreateStudioAxfCommodityRequest;
import com.jiejing.fitness.finance.api.axf.request.GetStudioAxfCommodityRequest;
import com.jiejing.paycenter.common.model.vo.CommodityVO;
import com.jiejing.paycenter.common.model.vo.CreateCommodityVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * 安心付
 *
 * @author chengyubing
 * @since 2024/9/7 11:00
 */
@FeignClient(name = "FINANCE", url = "${rpc.url.fit-finance:http://app-fit-finance:7008}", fallbackFactory = StudioAxfCommodityApiFallback.class)
public interface StudioAxfCommodityApi {

  @ApiOperation(value = "创建安心付一课一价商品")
  @PostMapping(value = "/private/axfCommodity/create")
  JsonResult<CreateCommodityVO> create(CreateStudioAxfCommodityRequest request);

  @ApiOperation(value = "查询安心付一课一价商品")
  @PostMapping(value = "/private/axfCommodity/get")
  JsonResult<CommodityVO> get(GetStudioAxfCommodityRequest request);

}
