package com.jiejing.fitness.finance.api.axf.vo;

import com.jiejing.paycenter.common.enums.common.OpenStateEnums;
import com.jiejing.paycenter.common.enums.merchant.CommodityTypeEnums;
import com.jiejing.paycenter.common.model.request.CycleCommodityAttr;
import com.jiejing.paycenter.common.model.vo.CommodityTemplateVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * <p>
 * 商品
 * </p>
 *
 * @author chengyubing, created on 2024-09-06
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "场馆安心付商品VO")
public class StudioAxfCommodityVO {

  @ApiModelProperty(value = "商品ID")
  private Long id;

  @ApiModelProperty(value = "业务ID")
  private Long bizId;

  @ApiModelProperty(value = "商户ID")
  private Long merchantId;

  @ApiModelProperty(value = "门店ID")
  private Long storeId;

  @ApiModelProperty(value = "商品模板ID")
  private Long templateId;

  @ApiModelProperty(value = "三方商品模板ID")
  private String thirdTemplateId;

  @ApiModelProperty(value = "三方商品ID")
  private String thirdCommodityId;

  @ApiModelProperty(value = "商品类型")
  private CommodityTypeEnums commodityType;

  @ApiModelProperty(value = "商品名称")
  private String commodityName;

  @ApiModelProperty(value = "原价（元）")
  private BigDecimal originalPrice;

  @ApiModelProperty(value = "售价（元）")
  private BigDecimal salePrice;

  @ApiModelProperty(value = "商品状态")
  private OpenStateEnums state;

  @ApiModelProperty(value = "售卖开始时间")
  private Date saleStartTime;

  @ApiModelProperty(value = "售卖结束时间")
  private Date saleEndTime;

  @ApiModelProperty(value = "商品属性")
  private String commodityAttr;

  @ApiModelProperty(value = "周期类商品属性")
  private CycleCommodityAttr cycleCommodityAttr;

  @ApiModelProperty(value = "商品说明")
  private String commodityNote;

  @ApiModelProperty(value = "商品模板")
  private CommodityTemplateVO template;

  @ApiModelProperty(value = "创建时间")
  private Date createTime;

  @ApiModelProperty(value = "更新时间")
  private Date updateTime;

}
