package com.jiejing.fitness.finance.api.merchant.vo;

import com.jiejing.common.swagger.EnumMapping;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantCheckRefundVO.CheckRefundCodeEnum;
import com.jiejing.paycenter.common.enums.common.TransStateEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/5/10 13:40
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "场馆商户退款VO")
public class StudioMerchantRefundVO {

  @ApiModelProperty(name = "退款单号")
  private String transNo;

  @EnumMapping(enumClass = TransStateEnums.class)
  @ApiModelProperty(name = "退款状态")
  private String refundState;

  @ApiModelProperty(name = "三方交易单号")
  private String thirdTransNo;

  @EnumMapping(enumClass = CheckRefundCodeEnum.class)
  @ApiModelProperty(value = "失败code")
  private String failCode;

  @ApiModelProperty(name = "失败原因")
  private String failMessage;

  @ApiModelProperty(name = "完成时间")
  private Date successTime;

}
