package com.jiejing.fitness.finance.service.axf.model;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * 核销订单变更通知
 *
 * @author chengyubing
 * @since 2024/9/7 17:15
 */
@Data
public class AlipayCommerceMerchantcardDeductionOrderNotifyModel {

  /**
   * 【描述】核销订单id 【示例值】1000100202405300000000100003
   */
  @JSONField(name = "deduction_order_id")
  private String deductionOrderId;

  /**
   * 核销订单状态 待支付: UNPAID 支付成功: PAYMENT_SUCCESS 支付失败: PAYMENT_FAILED 已退款: REFUND
   */
  @JSONField(name = "deduction_order_status")
  private String deductionOrderStatus;

  /**
   * 售卖订单id
   */
  @JSONField(name = "card_id")
  private String cardId;

  /**
   * 售卖订单对应的期数
   */
  @JSONField(name = "period")
  private String period;

  /**
   * 支付宝交易号
   */
  @JSONField(name = "trade_no")
  private String tradeNo;

  /**
   * 用户id
   * <p>
   * 新商户建议使用open_id替代该字段。对于新商户，user_id字段未来计划逐步回收，存量商户可继续使用。如使用open_id，请确认 应用-开发配置-openid配置管理
   * 已启用。无该配置项，可查看openid配置申请。
   */
  @JSONField(name = "user_id")
  private String userId;

  /**
   * 用于标记支付宝用户在应用下的唯一标识  详情可查看 openid简介
   */
  @JSONField(name = "open_id")
  private String openId;

  /**
   * 【描述】商品小程序appid
   */
  @JSONField(name = "card_template_app_id")
  private String cardTemplateAppId;

  /**
   * 卡ID
   */
  @JSONField(name = "card_template_id")
  private String cardTemplateId;

}
