package com.jiejing.fitness.finance.service.enums;

import com.jiejing.common.exception.BaseBizError;
import lombok.Getter;

/**
 * @author chengyubing
 * @since 2024/2/21 14:54
 */
@Getter
public enum FinanceErrorEnums implements BaseBizError {

  /**
   * 三方异常
   */
  REPEAT_SUBMIT("请勿重复提交"),
  NOT_EXIST("数据不存在"),
  NOT_SUPPORT_METHOD("不支持的方法"),
  NOT_SUPPORT_TYPE("不支持的类型"),
  CHANNEL_NOT_OPEN("未开通当前支付通道"),
  MERCHANT_NOT_OPEN("未进件"),
  NOT_SUPPORT_FILE_TYPE("不支持的文件类型"),
  EXIST_PROCESS_APPLY("存在处理中的申请"),
  EXIST_BIND_RECORD("存在已经绑定的流水"),
  PAY_FAIL_COMMON("支付失败，请联系场馆工作人员处理。"),
  PAY_FAIL_WX_AUTH("支付失败，请联系场馆工作人员进行微信授权。"),
  PAY_FAIL_ALI_AUTH("支付失败，请联系场馆工作人员进行支付宝授权。"),
  PAY_FAIL_AMOUNT_MIN("金额必须大于0元"),
  PAY_FAIL_AMOUNT_MAX("金额必须小于10000000元"),
  PAY_FAIL_NOT_OPEN("未开通线上支付，请联系场馆工作人员处理"),
  TOKEN_INVALID("token失效，请重新授权"),
  AGG_TIME_OUT("统计超时"),
  NOT_OPEN_AXF("未开通先学后付"),
  AXF_PERIOD_SALE_PRICE_ERROR("分期实扣金额计算错误"),
  AXF_PERIOD_ORIGINAL_PRICE_ERROR("分期原价金额计算错误"),

  ;

  private final String module = "PAY_CENTER";

  private final String code = name();

  private final String defaultMessage;

  FinanceErrorEnums(String defaultMessage) {
    this.defaultMessage = defaultMessage;
  }

}
