package com.jiejing.fitness.finance.service.rpc;

import com.jiejing.common.model.JsonResult;
import com.jiejing.filecenter.api.common.enums.AccessTypeEnum;
import com.jiejing.filecenter.api.resource.ResourceApi;
import com.jiejing.filecenter.api.resource.request.BatchQueryMultiResourceRequest;
import com.jiejing.filecenter.api.resource.vo.ResourceInfoVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

/**
 * @author chengyubing
 * @since 2024/1/25 18:05
 */
@Service
public class ResourceRpcService {

  @Resource
  private ResourceApi resourceApi;

  public Map<Long, ResourceInfoVO> getResourceMap(Long partyId, List<Long> resourceIds) {
    BatchQueryMultiResourceRequest request = new BatchQueryMultiResourceRequest();
    request.setAccessTypeEnum(AccessTypeEnum.PUBLIC);
    request.setResourceIds(resourceIds);
    request.setTenantId(partyId);
    request.setExpire(TimeUnit.SECONDS.toMillis(60));
    JsonResult<List<ResourceInfoVO>> result = resourceApi.getInfoByIds(request);
    return Optional.ofNullable(result.getResult())
        .map(list -> list.stream().collect(Collectors.toMap(ResourceInfoVO::getResourceId, e -> e)))
        .orElse(new HashMap<>(1));
  }

  public Map<Long, String> getResourceUrlMap(Long partyId, List<Long> resourceIds) {
    BatchQueryMultiResourceRequest request = new BatchQueryMultiResourceRequest();
    request.setAccessTypeEnum(AccessTypeEnum.PUBLIC);
    request.setResourceIds(resourceIds);
    request.setTenantId(partyId);
    request.setExpire(TimeUnit.SECONDS.toMillis(60));
    JsonResult<List<ResourceInfoVO>> result = resourceApi.getInfoByIds(request);
    return Optional.ofNullable(result.getResult())
        .map(list -> list.stream().collect(Collectors.toMap(ResourceInfoVO::getResourceId, e -> e.getUrl())))
        .orElse(new HashMap<>(1));
  }

}
