package com.jiejing.fitness.finance.api.merchant;

import com.jiejing.common.model.JsonResult;
import com.jiejing.fitness.finance.api.merchant.request.BindBrandMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.ListBrandMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.UnbindBrandMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantVO;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantVO;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author chengyubing
 * @since 2024/3/7 09:46
 */
@FeignClient(name = "FINANCE", url = "${rpc.url.fit-finance:http://app-fit-finance:7008}", fallbackFactory = BrandMerchantApiFallback.class)
public interface BrandMerchantApi {

  String TAG = "【品牌】商户管理";

  @ApiOperation(value = "品牌绑定商户", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/bind")
  JsonResult<Void> bind(BindBrandMerchantRequest request);

  @ApiOperation(value = "品牌解绑商户", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/unbind")
  JsonResult<Void> unbind(UnbindBrandMerchantRequest request);

  @ApiOperation(value = "查询品牌商户列表", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/list")
  JsonResult<List<BrandMerchantVO>> list(ListBrandMerchantRequest request);

}
