package com.jiejing.fitness.finance.api.axf.request;

import com.jiejing.fitness.finance.api.axf.enums.AxfStateEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/9/10 14:14
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "分页查询安心付申请记录")
public class PageStudioAxfApplyRequest {

  @ApiModelProperty(value = "场馆ID")
  private Long studioId;

  @ApiModelProperty(value = "场馆名称")
  private String studioName;

  @ApiModelProperty(value = "商户简称")
  private String shortName;

  @ApiModelProperty(value = "申请开始时间")
  private Date createTimeStart;

  @ApiModelProperty(value = "申请结束时间")
  private Date createTimeEnd;

  @ApiModelProperty(value = "开通状态")
  private List<AxfStateEnums> stateList;

  @ApiModelProperty(value = "页码", notes = "1开始")
  private Integer current;

  @ApiModelProperty(value = "分页大小")
  private Integer size = 10;

}
