/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jiejing.fitness.finance.api.axf.enums.AxfStateEnums;
import com.jiejing.fitness.finance.repository.entity.StudioAxfApply;
import com.jiejing.fitness.finance.repository.mapper.StudioAxfApplyMapper;
import com.jiejing.mbp.MapperRepoService;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 机构安心付申请记录 服务实现类
 * </p>
 *
 * @author chengyubing, created on 2024-11-04
 */
@Service
public class StudioAxfApplyRpService extends MapperRepoService<Long, StudioAxfApply, StudioAxfApplyMapper> {

  public Integer countProcessByStudioId(Long studioId) {
    QueryWrapper<StudioAxfApply> wrapper = new QueryWrapper<>();
    wrapper.eq(StudioAxfApply.STUDIO_ID, studioId);
    wrapper.in(StudioAxfApply.STATE,
        Lists.newArrayList(AxfStateEnums.INIT, AxfStateEnums.AXF_PROCESS, AxfStateEnums.STORE_PROCESS));
    Integer count = this.baseMapper.selectCount(wrapper);
    return Optional.ofNullable(count).orElse(0);
  }

  public StudioAxfApply getLatestOneByMerchantId(Long merchantId, AxfStateEnums state) {
    QueryWrapper<StudioAxfApply> wrapper = new QueryWrapper<>();
    wrapper.eq(StudioAxfApply.MERCHANT_ID, merchantId);
    wrapper.eq(StudioAxfApply.STATE, state);
    wrapper.orderByDesc(StudioAxfApply.ID);
    return this.baseMapper.selectPage(new Page<>(0, 1), wrapper).getRecords().stream().findFirst()
        .orElse(null);
  }

  public org.springframework.data.domain.Page<StudioAxfApply> page(Long studioId, String instName,
      String shortName, Date createTimeStart,
      Date createTimeEnd, List<AxfStateEnums> stateList, Integer current, Integer size) {
    QueryWrapper<StudioAxfApply> wrapper = new QueryWrapper<>();
    if (null != studioId) {
      wrapper.eq(StudioAxfApply.STUDIO_ID, studioId);
    }
    if (StringUtils.isNotBlank(instName)) {
      wrapper.like(StudioAxfApply.STUDIO_NAME, instName);
    }
    if (StringUtils.isNotBlank(shortName)) {
      wrapper.like(StudioAxfApply.SHORT_NAME, shortName);
    }
    if (CollectionUtils.isNotEmpty(stateList)) {
      wrapper.in(StudioAxfApply.STATE, stateList);
    }
    if (null != createTimeStart) {
      wrapper.ge(StudioAxfApply.CREATE_TIME, createTimeStart);
    }
    if (null != createTimeEnd) {
      wrapper.le(StudioAxfApply.CREATE_TIME, createTimeEnd);
    }
    wrapper.orderByDesc(StudioAxfApply.ID);
    return this.findByWrapperPage(wrapper, current, size);
  }

  public StudioAxfApply getLatestOneByMerchantNo(Long studioId, String merchantNo) {
    QueryWrapper<StudioAxfApply> wrapper = new QueryWrapper<>();
    wrapper.eq(StudioAxfApply.STUDIO_ID, studioId);
    if (StringUtils.isNotBlank(merchantNo)) {
      wrapper.eq(StudioAxfApply.MERCHANT_NO, merchantNo);
    }
    wrapper.orderByDesc(StudioAxfApply.ID);
    return this.baseMapper.selectPage(new Page<>(0, 1), wrapper).getRecords().stream().findFirst()
        .orElse(null);
  }

  public int countDistinctStudioId() {
    return this.baseMapper.countDistinctStudioId();
  }

}
