package com.jiejing.fitness.finance.api.axf.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * @author chengyubing
 * @since 2024/9/29 11:10
 */
@Data
@ApiModel(description = "绑定结算账户")
public class BindAxfSettleAccountRequest {

  @ApiModelProperty(value = "申请记录ID", required = true)
  @NotNull(message = "申请记录ID不能为空")
  private Long id;

  @ApiModelProperty(value = "结算账户", required = true)
  @NotBlank(message = "结算账户不能为空")
  private String cardNo;

}
