/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.entity;

import com.jiejing.fitness.enums.finance.BrandCashierTransStateEnum;
import com.jiejing.fitness.enums.finance.BrandCashierTransTypeEnum;
import com.jiejing.paycenter.common.enums.merchant.SubChannelEnums;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * <p>
 * 场馆收银流水
 * </p>
 *
 * @author chengyubing, created on 2024-02-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
public class StudioCashierRecord implements Serializable {

  private static final long serialVersionUID = -4723670005434909301L;

  /**
   * 是否允许为null: NO
   */
  @TableId(value = "id", type = IdType.ID_WORKER)
  private Long id;

  /**
   * 备注: 交易流水号 是否允许为null: NO
   */
  private String transNo;

  /**
   * 备注: 业务订单号 是否允许为null: NO
   */
  private String orderNo;

  /**
   * 备注: 业务订单类型 是否允许为null: YES
   */
  private String orderType;

  /**
   * 备注: 业务子订单号 是否允许为null: NO
   */
  private String subOrderNo;

  /**
   * 备注: 交易类型：PAY-收款；REFUND-退款； 默认值: 空字符串 是否允许为null: YES
   *
   * @see BrandCashierTransTypeEnum
   */
  private String transType;

  /**
   * 备注: 品牌ID 是否允许为null: NO
   */
  private Long brandId;

  /**
   * 备注: 场馆ID 默认值: -1 是否允许为null: NO
   */
  private Long studioId;

  /**
   * 场馆名称
   */
  private String studioName;

  /**
   * 备注: 商户ID 是否允许为null: YES
   */
  private Long merchantId;

  /**
   * 备注: 商户号 默认值: 空字符串 是否允许为null: YES
   */
  private String merchantNo;

  /**
   * 备注: 渠道号 默认值: 空字符串 是否允许为null: YES
   */
  private String channelNo;

  /**
   * 备注: 支付子渠道：ALI-支付宝、WX-微信 默认值: 空字符串 是否允许为null: YES
   *
   * @see SubChannelEnums
   */
  private String subChannel;

  /**
   * 备注: 交易金额（元） 默认值: 0.00 是否允许为null: NO
   */
  private BigDecimal transAmount;

  /**
   * 备注: 交易手续费率（%） 默认值: 0.00 是否允许为null: NO
   */
  private BigDecimal feeRate;

  /**
   * 备注: 交易手续费 默认值: 0.00 是否允许为null: NO
   */
  private BigDecimal fee;

  /**
   * 备注: 实际金额（元） 默认值: 0.00 是否允许为null: NO
   */
  private BigDecimal actualAmount;

  /**
   * 备注: 交易状态
   *
   * @see BrandCashierTransStateEnum
   */
  private String transState;

  /**
   * 备注: 付款人姓名 是否允许为null: YES
   */
  private String buyerName;

  /**
   * 备注: 付款人手机号 是否允许为null: YES
   */
  private String buyerPhone;

  /**
   * 备注: 商品名称 是否允许为null: YES
   */
  private String goods;

  /**
   * 备注: 备注 是否允许为null: YES
   */
  private String remark;

  /**
   * 备注: 是否存在关联交易 默认值: 0 是否允许为null: YES
   */
  private Boolean existRelatedTrans;

  /**
   * 备注: 关联的交易单号 是否允许为null: NO
   */
  private String relatedTransNo;

  /**
   * 备注: 三方交易单号 是否允许为null: NO
   */
  private String thirdTransNo;

  /**
   * 备注: 错误信息 默认值: 空字符串 是否允许为null: YES
   */
  private String failMessage;

  /**
   * 扩展信息
   */
  private String extra;

  /**
   * 备注: 交易发生时间 是否允许为null: YES
   */
  private Date tradingTime;

  /**
   * 备注: 交易成功时间 是否允许为null: YES
   */
  private Date successTime;

  /**
   * 备注: 入账时间 是否允许为null: YES
   */
  private Date inTime;

  /**
   * 备注: 创建时间 默认值: CURRENT_TIMESTAMP 是否允许为null: YES
   */
  private Date createTime;

  /**
   * 备注: 更新时间 默认值: CURRENT_TIMESTAMP 是否允许为null: YES
   */
  private Date updateTime;


  public static final String ID = "id";

  public static final String TRANS_NO = "trans_no";

  public static final String ORDER_NO = "order_no";

  public static final String SUB_ORDER_NO = "sub_order_no";

  public static final String ORDER_TYPE = "order_type";

  public static final String TRANS_TYPE = "trans_type";

  public static final String BRAND_ID = "brand_id";

  public static final String STUDIO_ID = "studio_id";

  public static final String STUDIO_NAME = "studio_name";

  public static final String MERCHANT_ID = "merchant_id";

  public static final String MERCHANT_NO = "merchant_no";

  public static final String CHANNEL_NO = "channel_no";

  public static final String SUB_CHANNEL = "sub_channel";

  public static final String TRANS_AMOUNT = "trans_amount";

  public static final String FEE_RATE = "fee_rate";

  public static final String FEE = "fee";

  public static final String ACTUAL_AMOUNT = "actual_amount";

  public static final String TRANS_STATE = "trans_state";

  public static final String BUYER_NAME = "buyer_name";

  public static final String BUYER_PHONE = "buyer_phone";

  public static final String GOODS = "goods";

  public static final String REMARK = "remark";

  public static final String EXIST_RELATED_TRANS = "exist_related_trans";

  public static final String RELATED_TRANS_NO = "related_trans_no";

  public static final String THIRD_TRANS_NO = "third_trans_no";

  public static final String FAIL_MESSAGE = "fail_message";

  public static final String EXTRA = "extra";

  public static final String TRADING_TIME = "trading_time";

  public static final String SUCCESS_TIME = "success_time";

  public static final String IN_TIME = "in_time";

  public static final String CREATE_TIME = "create_time";

  public static final String UPDATE_TIME = "update_time";

}
