package com.jiejing.fitness.finance.service.utils;

import com.jiejing.common.dingtalk.chatbot.DingtalkChatbotClient;
import com.jiejing.common.dingtalk.chatbot.message.MarkdownMessage;
import com.jiejing.common.dingtalk.chatbot.message.Message;
import com.jiejing.common.dingtalk.chatbot.message.TextMessage;
import java.io.IOException;
import lombok.extern.slf4j.Slf4j;

/**
 * @author chengyubing
 * @since 2024/4/7 17:13
 */
@Slf4j
public class DingUtil {

  public static final String URL = "https://oapi.dingtalk.com/robot/send?access_token=1d52fb498b3d23687dec5aebf5907fb73acde3f29709fc672386d67451c9dfb7";

  private static final String CHECK_SETTLE_SUCCESS = "%s【告警】【乐动收银自动结算记录对账】全部对账成功";
  private static final String CHECK_SETTLE_FAIL = "%s【告警】【乐动收银自动结算记录对账】有%s家对账失败，请人工跟进";
  private static final String CREATE_COMMODITY_TEMPLATE_FAIL = "【%s】【告警】场馆id%s，先享后付商品创建失败，商品id为%s，请立即处理";

  public static void sendCheckSettleFail(String env, Integer total) {
    Message message = new TextMessage(String.format(CHECK_SETTLE_FAIL, env, total));
    try {
      DingtalkChatbotClient.send(URL, message);
    } catch (IOException e) {
      log.error("发送对账失败告警失败", e);
    }
  }

  public static void sendCheckSettleSuccess(String env) {
    Message message = new TextMessage(String.format(CHECK_SETTLE_SUCCESS, env));
    try {
      DingtalkChatbotClient.send(URL, message);
    } catch (IOException e) {
      log.error("发送对账成功告警失败", e);
    }
  }

  public static void sendCreateCommodityTemplateFail(String env, Long studioId, Long id) {
    try {
      String text = String.format(CREATE_COMMODITY_TEMPLATE_FAIL, env, studioId, id);
      TextMessage textMessage = new TextMessage(text);
      DingtalkChatbotClient.send(URL, textMessage);
    } catch (IOException e) {
      log.error("sendCreateCommodityTemplateFail {}, {}", studioId, id, e);
    }
  }
}
