package com.jiejing.fitness.finance.service.pay.params;

import com.alibaba.fastjson.JSONObject;
import com.jiejing.paycenter.common.enums.merchant.SubChannelEnums;
import com.jiejing.paycenter.common.enums.pay.PayTypeEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/27 10:54
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "品牌商户退款Params")
public class BrandMerchantRefundParams {

  @ApiModelProperty(value = "场馆ID", required = true)
  @NotNull(message = "场馆ID不能为空")
  private Long studioId;

  @ApiModelProperty(name = "支付总金额（元）", required = true)
  @NotNull(message = "支付总金额不能为空")
  private BigDecimal transAmount;

  @ApiModelProperty(name = "业务订单号", required = true)
  @NotBlank(message = "业务订单号不能为空")
  private String orderNo;

  @ApiModelProperty(name = "业务订单类型", required = true)
  @NotNull(message = "业务订单类型不能为空")
  private Integer orderType;

  @ApiModelProperty(name = "支付类型", required = true)
  @NotNull(message = "支付类型不能为空")
  private PayTypeEnums payType;

  @ApiModelProperty(name = "正扫：三方支付账户ID", notes = "微信的openId，支付宝的userId，JS、MINI、NATIVE支付必传")
  private String openId;

  @ApiModelProperty(name = "反扫：支付授权码", notes = "扫码设备读出的条形码或者二维码信息，BARCODE支付必传")
  private String authCode;

  @ApiModelProperty(name = "支付子渠道", notes = "聚合支付时需要")
  private SubChannelEnums subChannel;

  @ApiModelProperty(name = "商品名称", required = true)
  @NotBlank(message = "商品名称不能为空")
  private String goods;

  @ApiModelProperty(name = "付款人姓名", required = true)
  @NotBlank(message = "付款人姓名不能为空")
  @Size(max = 30)
  private String buyerName;

  @ApiModelProperty(name = "付款人手机号", required = true)
  @NotBlank(message = "付款人手机号不能为空")
  @Size(max = 11)
  private String buyerPhone;

  @ApiModelProperty(name = "备注")
  private String remark;

  @ApiModelProperty(name = "appId", notes = "指定本次使用的appId")
  private String appId;

  @ApiModelProperty(name = "过期时间（单位：秒）", required = true)
  @NotNull(message = "过期时间不能为空")
  private Integer timeExpire;

  @ApiModelProperty(name = "业务扩展信息")
  private JSONObject extra;

}
