package com.jiejing.fitness.finance.service.rpc;

import com.jiejing.common.model.JsonResult;
import com.jiejing.paycenter.api.pay.PayApi;
import com.jiejing.paycenter.api.pay.request.PayRequest;
import com.jiejing.paycenter.api.pay.request.RefundPayRequest;
import com.jiejing.paycenter.api.pay.vo.PayVO;
import com.jiejing.paycenter.api.pay.vo.RefundVO;
import com.jiejing.paycenter.common.enums.pay.PayStateEnums;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

/**
 * @author chengyubing
 * @since 2024/2/27 11:12
 */
@Service
public class PayRpcService {

  @Resource
  private PayApi payApi;

  public PayVO pay(PayRequest request) {
    try {
      JsonResult<PayVO> result = payApi.pay(request);
      result.assertSuccess();
      return result.getResult();
    } catch (Exception e) {
      return PayVO.builder().payState(PayStateEnums.FAILED).failMsg(e.getMessage()).build();
    }
  }

  public RefundVO refund(RefundPayRequest request) {
    JsonResult<RefundVO> result = payApi.refund(request);
    result.assertSuccess();
    return result.getResult();
  }

}
