package com.jiejing.fitness.finance.api.axf.request;

import com.jiejing.paycenter.common.enums.merchant.GrantTypeEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/9/5 15:17
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "授权Token请求参数")
public class AxfAuthTokenRequest {

  @ApiModelProperty(value = "code")
  private String code;

  @ApiModelProperty(value = "grantType")
  private GrantTypeEnums grantType;

  @ApiModelProperty(value = "refreshToken")
  private String refreshToken;

  @ApiModelProperty(value = "场馆ID", required = true)
  @NotNull(message = "场馆ID不能为空")
  private Long studioId;

}
