package com.jiejing.fitness.finance.app.controller.axf;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.common.request.IdRequest;
import com.jiejing.fitness.finance.api.axf.StudioAxfApi;
import com.jiejing.fitness.finance.api.axf.request.*;
import com.jiejing.fitness.finance.api.axf.vo.*;
import com.jiejing.fitness.finance.service.axf.AxfService;
import com.jiejing.fitness.request.StudioIdRequest;
import com.jiejing.paycenter.common.model.vo.BindCardVO;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chengyubing
 * @since 2024/9/7 11:30
 */
@RestController
public class StudioAxfController implements StudioAxfApi {

  @Resource
  private AxfService axfService;

  @ApiOperation(value = "authToken")
  @PostMapping(value = "/private/axf/authToken")
  @Override
  public JsonResult<StudioAuthTokenVO> authToken(@RequestBody @Valid AxfAuthTokenRequest request) {
    return JsonResult.success(
        axfService.authToken(request.getStudioId(), request.getGrantType(), request.getCode(),
            request.getRefreshToken()));
  }

  @ApiOperation(value = "getAuthToken")
  @PostMapping(value = "/private/axf/getAuthToken")
  @Override
  public JsonResult<StudioAuthTokenVO> getAuthToken(@RequestBody @Valid GetAxfAuthTokenRequest request) {
    return JsonResult.success(axfService.getAuthToken(request.getStudioId()));
  }

  @ApiOperation(value = "申请开通安心付")
  @PostMapping(value = "/private/axf/apply")
  @Override
  public JsonResult<Long> apply(@RequestBody @Valid StudioAxfApplyRequest request) {
    return JsonResult.success(axfService.apply(request));
  }

  @ApiOperation(value = "查询可绑定的安心付结算账户")
  @PostMapping(value = "/private/axf/listSettleAccount")
  @Override
  public JsonResult<List<String>> listSettleAccount(@RequestBody @Valid ListAxfSettleAccountRequest request) {
    return JsonResult.success(axfService.listSettleAccount(request.getStudioId()));
  }

  @ApiOperation(value = "绑定结算账户")
  @PostMapping(value = "/private/axf/bindCard")
  @Override
  public JsonResult<BindCardVO> bindCard(@RequestBody @Valid BindAxfSettleAccountRequest request) {
    return JsonResult.success(axfService.bindCard(request.getId(), request.getCardNo()));
  }

  @ApiOperation(value = "获取最新一条安心付申请记录")
  @PostMapping(value = "/private/axf/getLatestApply")
  @Override
  public JsonResult<StudioAxfApplyVO> getLatestApply(@RequestBody @Valid GetLatestAxfApplyRequest request) {
    return JsonResult.success(axfService.getLatestApply(request.getStudioId(), request.getMerchantNo()));
  }

  @ApiOperation(value = "查询开通安心付申请结果")
  @PostMapping(value = "/private/axf/getById")
  @Override
  public JsonResult<StudioAxfApplyVO> getById(@RequestBody @Valid IdRequest request) {
    return JsonResult.success(axfService.getById(request.getId()));
  }

  @ApiOperation(value = "获取当前绑定的商户信息（开通中、开通失败、未开通都返回null）")
  @PostMapping(value = "/private/axf/getMerchant")
  @Override
  public JsonResult<StudioAxfApplyVO> getMerchant(@RequestBody @Valid StudioIdRequest request) {
    return JsonResult.success(axfService.getMerchant(request.getStudioId()));
  }

  @ApiOperation(value = "分页查询开通安心付申请记录")
  @PostMapping(value = "/private/axf/page")
  @Override
  public JsonResult<PageVO<StudioAxfApplyVO>> page(@RequestBody @Valid PageStudioAxfApplyRequest request) {
    return JsonResult.success(axfService.page(request));
  }

  @ApiOperation(value = "统计")
  @PostMapping(value = "/private/axf/agg")
  @Override
  public JsonResult<AggStudioAxfApplyVO> agg() {
    return JsonResult.success(axfService.agg());
  }

}
