/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * <p>
 * 场馆商品标品申请表
 * </p>
 *
 * @author chengyubing, created on 2024-11-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
public class StudioAxfCommodityTemplateApply implements Serializable {

  private static final long serialVersionUID = -166947593419927514L;

  /**
   * 备注: 主键ID
   * 是否允许为null: NO
   */
  @TableId(value = "id", type = IdType.ID_WORKER)
  private Long id;

  /**
   * 备注: 场馆ID
   * 是否允许为null: NO
   */
  private Long studioId;

  /**
   * 备注: 商户ID
   * 是否允许为null: YES
   */
  private Long merchantId;

  /**
   * 备注: 商品模板ID
   * 是否允许为null: YES
   */
  private Long templateId;

  /**
   * 备注: 三方商品ID
   * 是否允许为null: YES
   */
  private String thirdTemplateId;

  /**
   * 备注: 商品模板名称
   * 是否允许为null: YES
   */
  private String templateName;

  /**
   * 备注: 申请状态
   * 是否允许为null: YES
   */
  private String state;

  /**
   * 备注: 是否立即扣首期款
   * 默认值: 0
   * 是否允许为null: YES
   */
  private Boolean chargeNow;

  /**
   * 备注: 总期数
   * 是否允许为null: YES
   */
  private Integer totalPeriod;

  /**
   * 备注: 周期类型
   * 是否允许为null: YES
   */
  private String cycleType;

  /**
   * 备注: 周期计费类型
   * 是否允许为null: YES
   */
  private String cycleChargeType;

  /**
   * 备注: 周期计费参数
   * 是否允许为null: YES
   */
  private Integer cycleValue;

  /**
   * 备注: 售卖开始时间
   * 是否允许为null: YES
   */
  private Date saleStartTime;

  /**
   * 备注: 售卖结束时间
   * 是否允许为null: YES
   */
  private Date saleEndTime;

  /**
   * 备注: 其他属性
   * 是否允许为null: YES
   */
  private String attr;

  /**
   * 备注: 失败原因
   * 是否允许为null: YES
   */
  private String failMessage;

  /**
   * 备注: 创建时间
   * 是否允许为null: YES
   */
  private Date createTime;

  /**
   * 备注: 更新时间
   * 是否允许为null: YES
   */
  private Date updateTime;


  public static final String ID = "id";

  public static final String STUDIO_ID = "studio_id";

  public static final String MERCHANT_ID = "merchant_id";

  public static final String TEMPLATE_ID = "template_id";

  public static final String THIRD_TEMPLATE_ID = "third_template_id";

  public static final String TEMPLATE_NAME = "template_name";

  public static final String STATE = "state";

  public static final String CHARGE_NOW = "charge_now";

  public static final String TOTAL_PERIOD = "total_period";

  public static final String CYCLE_TYPE = "cycle_type";

  public static final String CYCLE_CHARGE_TYPE = "cycle_charge_type";

  public static final String CYCLE_VALUE = "cycle_value";

  public static final String SALE_START_TIME = "sale_start_time";

  public static final String SALE_END_TIME = "sale_end_time";

  public static final String ATTR = "attr";

  public static final String FAIL_MESSAGE = "fail_message";

  public static final String CREATE_TIME = "create_time";

  public static final String UPDATE_TIME = "update_time";

}
