package com.jiejing.fitness.finance.app;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceAutoConfigure;
import com.jiejing.common.config.idgen.EnableLeaseIdWorker;
import com.jiejing.filecenter.api.common.event.ResourceEvent;
import com.jiejing.fitness.finance.service.event.ListenerService;
import com.jiejing.paycenter.common.event.MerchantEvent;
import com.jiejing.paycenter.common.event.MerchantSubChannelConfigEvent;
import com.jiejing.paycenter.common.event.PayEvent;
import com.xiaomai.event.annotation.EnableEventBinding;
import com.xiaomai.event.annotation.EventConfig;
import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * @author chengyubing
 * @since 2024/2/19 16:04
 */
@Slf4j
@EnableAsync
@EnableScheduling
@EnableLeaseIdWorker
@MapperScan(value = {"com.jiejing.fitness.finance.repository.mapper"})
@EnableEventBinding(
    configs = {
        @EventConfig(event = PayEvent.class, binder = "biz-kafka"),
        @EventConfig(event = MerchantEvent.class, binder = "biz-kafka"),
        @EventConfig(event = MerchantSubChannelConfigEvent.class, binder = "biz-kafka")
    },
    listenerClass = {ListenerService.class})
@EnableFeignClients(basePackages = {
    "com.jiejing.filecenter.api",
    "com.jiejing.paycenter.api",
    "com.jiejing.studio.api",
})
@SpringBootApplication(scanBasePackages = "com.jiejing", exclude = {
    DruidDataSourceAutoConfigure.class
})
public class FitnessFinanceApplication {

  public static void main(String[] args) {
    SpringApplication.run(FitnessFinanceApplication.class, args);
    System.out.println("FitnessFinanceApplication start success!");
    log.info("FitnessFinanceApplication start success!");
  }

}
