package com.jiejing.fitness.finance.service.event;

import static org.springframework.integration.IntegrationMessageHeaderAccessor.DELIVERY_ATTEMPT;

import com.alibaba.fastjson.JSON;
import com.jiejing.fitness.finance.api.enums.MerchantTypeEnums;
import com.jiejing.fitness.finance.service.merchant.BrandMerchantService;
import com.jiejing.paycenter.common.event.MerchantEvent;
import com.xiaomai.event.annotation.EventHandler;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Service;

/**
 * @author chengyubing
 * @since 2024/2/21 14:30
 */
@Slf4j
@Service
public class ListenerService {

  private static final int MAX_RETRY = 3;

  @Resource
  private BrandMerchantService brandMerchantService;

  @EventHandler(value = MerchantEvent.class, binder = "biz-kafka", maxAttempts = MAX_RETRY)
  public void handleMerchantEvent(MerchantEvent event, @Header(DELIVERY_ATTEMPT) int retryNum) {
    try {
      log.info("start process merchant event {}, {}, {}", event.getApplyNo(), event.getMerchantId(),
          event.getMerchantNo());
      event.setSubChannels(Optional.ofNullable(event.getSubChannels()).orElse(new ArrayList<>(1)));
      event.setSubChannelAuths(Optional.ofNullable(event.getSubChannelAuths()).orElse(new ArrayList<>(1)));

      MerchantTypeEnums merchantType = MerchantTypeEnums.getByCode(event.getBizCode());
      switch (merchantType) {
        case BRAND:
          brandMerchantService.callback(event);
          break;
        default:
          break;
      }
    } catch (Exception e) {
      log.error("merchant event callback process fail {}", JSON.toJSONString(event));
    }
  }

}
