/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jiejing.fitness.finance.repository.entity.StudioAxfOrderDeduction;
import com.jiejing.fitness.finance.repository.mapper.StudioAxfOrderDeductionMapper;
import com.jiejing.mbp.MapperRepoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 场馆先享后付订购单扣款记录 服务实现类
 * </p>
 *
 * @author chengyubing, created on 2024-11-04
 */
@Service
public class StudioAxfOrderDeductionRpService extends
    MapperRepoService<Long, StudioAxfOrderDeduction, StudioAxfOrderDeductionMapper> {

  public List<StudioAxfOrderDeduction> listByOrderId(Long orderId) {
    QueryWrapper<StudioAxfOrderDeduction> wrapper = new QueryWrapper<>();
    wrapper.eq(StudioAxfOrderDeduction.ORDER_ID, orderId);
    wrapper.orderByDesc(StudioAxfOrderDeduction.PERIOD);
    return Optional.ofNullable(this.baseMapper.selectList(wrapper)).orElse(new ArrayList<>(1));
  }

  public Integer incRecoveryTimes(Long id) {
    this.baseMapper.incRecoveryTimes(id);
    return this.getById(id).orElse(new StudioAxfOrderDeduction()).getRecoveryTimes();
  }

}
