package com.jiejing.fitness.finance.service.rpc;

import com.google.common.collect.Lists;
import com.jiejing.common.model.JsonResult;
import com.jiejing.common.request.IdRequest;
import com.jiejing.common.request.IdsRequest;
import com.jiejing.common.utils.collection.CollectionUtil;
import com.jiejing.fitness.enums.studio.AdminStudioStatusEnum;
import com.jiejing.fitness.request.IdNameRequest;
import com.jiejing.fitness.vo.IdNameVO;
import com.jiejing.studio.api.admin.AdminApi;
import com.jiejing.studio.api.admin.vo.AdminVO;
import com.jiejing.studio.api.admin.vo.BaseAdminVO;
import com.jiejing.studio.api.studio.StudioApi;
import com.jiejing.studio.api.studio.request.GetStudioAdminRequest;
import com.jiejing.studio.api.studio.vo.StudioVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author chengyubing
 * @since 2024/2/20 16:52
 */
@Slf4j
@Service
public class StudioRpcService {

  @Resource
  private StudioApi studioApi;

  @Resource
  private AdminApi adminApi;

  public AdminVO getAdmin(Long id) {
    return adminApi.getAdmin(IdRequest.builder().id(id).build()).assertAndReturn().getResult();
  }

  public BaseAdminVO getBossAdmin(Long id) {
    JsonResult<Map<Long, BaseAdminVO>> result = adminApi.listStudioBoss(IdsRequest.builder().ids(Lists.newArrayList(id)).build());
    result.assertSuccess();
    return result.getResult().get(id);
  }

  public List<Long> listAdminIdsByUserIds(Long studioId, List<Long> userIds) {
    GetStudioAdminRequest request = new GetStudioAdminRequest();
    request.setStudioId(studioId);
    request.setState(AdminStudioStatusEnum.DUTY);
    request.setUserIds(userIds);
    return Optional.ofNullable(adminApi.getStudioAdminIds(request).getResult()).orElse(new ArrayList<>(1));
  }

  public StudioVO getStudio(Long studioId) {
    JsonResult<StudioVO> result = studioApi.getStudio(IdRequest.builder().id(studioId).build());
    result.assertSuccess();
    return result.getResult();
  }

  public Map<Long, StudioVO> mapStudio(List<Long> studioIds) {
    List<StudioVO> list = this.listStudio(studioIds);
    return list.stream().collect(Collectors.toMap(StudioVO::getId, e -> e));
  }

  public List<StudioVO> listStudio(List<Long> studioIds) {
    JsonResult<List<StudioVO>> result = studioApi.listStudio(IdsRequest.builder().ids(studioIds).build());
    result.assertSuccess();
    return Optional.ofNullable(result.getResult()).orElse(new ArrayList<>());
  }

  public Map<Long, List<StudioVO>> mapStudioByBrandId(List<Long> studioIds) {
    return this.listStudio(studioIds)
        .stream()
        .collect(Collectors.groupingBy(StudioVO::getBrandId));
  }

  public List<Long> queryStudioIdsByNameLike(String name){
    IdNameRequest request = new IdNameRequest();
    request.setIdOrName(name);
    JsonResult<List<IdNameVO>> jsonResult = studioApi.selectStudioList(request);
    jsonResult.assertSuccess();
    List<IdNameVO> idNameVOS = jsonResult.getResult();
    if (CollectionUtil.isNotEmpty(idNameVOS)){
      return idNameVOS.stream().map(IdNameVO::getId).collect(Collectors.toList());
    }
    return Lists.newArrayList();
  }


}
