package com.jiejing.fitness.finance.api.merchant.vo;

import com.jiejing.common.swagger.EnumMapping;
import com.jiejing.paycenter.common.enums.common.OpenStateEnums;
import com.jiejing.paycenter.common.enums.merchant.AuthPhaseEnums;
import com.jiejing.paycenter.common.enums.merchant.SubChannelAuthTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.SubChannelEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/26 14:37
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "场馆商户认证子渠道VO")
public class StudioMerchantAuthSubChannelVO {

  @ApiModelProperty(value = "申请单")
  private String applyNo;

  @EnumMapping(enumClass = SubChannelEnums.class)
  @ApiModelProperty(value = "子渠道类型")
  private String subChannel;

  @EnumMapping(enumClass = SubChannelAuthTypeEnums.class)
  @ApiModelProperty(value = "认证类型")
  private String authType;

  @EnumMapping(enumClass = OpenStateEnums.class)
  @ApiModelProperty(value = "授权状态")
  private String state;

  @EnumMapping(enumClass = AuthPhaseEnums.class)
  @ApiModelProperty(value = "认证阶段")
  private String phase;

  @ApiModelProperty(value = "授权二维码")
  private String qrCode;

  @ApiModelProperty(value = "失败原因")
  private String failMessage;

  @ApiModelProperty(value = "子商户号")
  private List<String> merchantNos;

}
