package com.jiejing.fitness.finance.api.cashier;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.cashier.request.BindStudioCashierRequest;
import com.jiejing.fitness.finance.api.cashier.request.GetStudioCashierByIdRequest;
import com.jiejing.fitness.finance.api.cashier.request.GetStudioSettleRequest;
import com.jiejing.fitness.finance.api.cashier.request.ListRelatedStudioCashierRecordRequest;
import com.jiejing.fitness.finance.api.cashier.request.ListStudioCashierByIdsRequest;
import com.jiejing.fitness.finance.api.cashier.request.ListStudioCashierByOrderNoRequest;
import com.jiejing.fitness.finance.api.cashier.request.ListStudioCashierByOrderNosRequest;
import com.jiejing.fitness.finance.api.cashier.request.ListStudioCashierBySubOrderNoRequest;
import com.jiejing.fitness.finance.api.cashier.request.ListStudioCashierByTransNoRequest;
import com.jiejing.fitness.finance.api.cashier.request.PageStudioCashierRequest;
import com.jiejing.fitness.finance.api.cashier.request.PageStudioSettleRequest;
import com.jiejing.fitness.finance.api.cashier.request.UnbindStudioCashierRequest;
import com.jiejing.fitness.finance.api.cashier.vo.StudioCashierRecordVO;
import com.jiejing.fitness.finance.api.cashier.vo.StudioCashierStatisticVO;
import com.jiejing.fitness.finance.api.cashier.vo.StudioSettleVO;
import com.jiejing.paycenter.common.enums.common.PayChannelEnums;
import feign.hystrix.FallbackFactory;
import java.util.List;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author chengyubing
 * @since 2024/2/29 10:42
 */
@Slf4j
@Component
public class StudioCashierApiFallback implements FallbackFactory<StudioCashierApi> {

  @Override
  public StudioCashierApi create(Throwable throwable) {
    return new StudioCashierApi() {

      @Override
      public JsonResult<Map<PayChannelEnums, String>> getAppId() {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<Void> bind(BindStudioCashierRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<Void> unbind(UnbindStudioCashierRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<PageVO<StudioCashierRecordVO>> page(PageStudioCashierRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<StudioCashierStatisticVO> statistic(PageStudioCashierRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<StudioCashierRecordVO> getById(GetStudioCashierByIdRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<List<StudioCashierRecordVO>> listByRelatedTransNo(
          ListRelatedStudioCashierRecordRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<List<StudioCashierRecordVO>> listByIds(ListStudioCashierByIdsRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<List<StudioCashierRecordVO>> listByTransNo(
          ListStudioCashierByTransNoRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<List<StudioCashierRecordVO>> listByOrderNo(
          ListStudioCashierByOrderNoRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<List<StudioCashierRecordVO>> listByOrderNos(
          ListStudioCashierByOrderNosRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<List<StudioCashierRecordVO>> listBySubOrderNo(
          ListStudioCashierBySubOrderNoRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<PageVO<StudioSettleVO>> pageSettle(PageStudioSettleRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<StudioSettleVO> getSettle(GetStudioSettleRequest request) {
        return JsonResult.rpcError();
      }

    };
  }
}
