package com.jiejing.fitness.finance.api.merchant.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/3/5 13:39
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "品牌绑定商户请求")
public class BindBrandMerchantRequest {

  @ApiModelProperty(value = "品牌ID", required = true)
  @NotNull(message = "品牌ID不能为空")
  private Long brandId;

  @ApiModelProperty(value = "商户ID", required = true)
  @NotNull(message = "商户ID不能为空")
  private Long merchantId;

}
