package com.jiejing.fitness.finance.api.merchant.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/8/13 15:28
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "绑定半屏小程序")
public class BindStudioEmbeddedXcxRequest {

  @ApiModelProperty(value = "场馆ID", required = true)
  @NotNull(message = "场馆ID不能为空")
  private Long studioId;

  @ApiModelProperty(value = "小程序appId", required = true)
  @NotBlank(message = "小程序appId不能为空")
  private String appId;

}
