package com.jiejing.fitness.finance.app.controller;

import com.alibaba.fastjson.JSON;
import com.jiejing.cash.sdk.CashClient;
import com.jiejing.cash.sdk.config.CashConfig;
import com.jiejing.cash.sdk.domain.GetOpenIdModel;
import com.jiejing.cash.sdk.enums.EnvEnums;
import com.jiejing.cash.sdk.request.GetWxOpenIdRequest;
import com.jiejing.cash.sdk.response.GetWxOpenIdResponse;
import com.jiejing.common.model.JsonResult;
import com.jiejing.fitness.finance.service.merchant.StudioMerchantService;
import com.jiejing.paycenter.api.merchant.MerchantQueryApi;
import com.jiejing.paycenter.common.event.MerchantEvent;

import java.math.BigDecimal;
import java.util.Map;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chengyubing
 * @since 2024/2/26 10:01
 */
@Slf4j
@RestController
public class TestController {

  @Resource
  private MerchantQueryApi merchantApi;

  private StudioMerchantService studioMerchantService;


  @PostMapping(value = "/private/test/merchantCallback")
  public JsonResult<Map<Long, BigDecimal>> merchantCallback(@RequestBody MerchantEvent event) {
    studioMerchantService.callback(event);
    return JsonResult.success();
  }


  CashConfig CONFIG = CashConfig.builder()
      .env(EnvEnums.DEV)
      .appId("20241209efJvUtzTNYJ")
      .appPrivateKey(
          "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAJQ/tcZc70JugQapZI40GYOPLqlmtqndKsaWPoUxrJvXPg/EqsvQu7rc4BRci17UKoHtqYxfHFLS7YUcepYvA2CWVUTeeZFoUTUEpX/IJsumFCQ3nhztGZkpt1gfHmXWP/TbxVlS9sqFDMmAg8mIXLVuE/7Rhq43OKf77qeX4WvzAgMBAAECgYAithwouv/mjRs25Ri/VyGWNUNWtM8WTMvEPc+bvjrNLoPAi2r2WARsx2TMP7L+XC0ryOsHDAoEtpCYt0dYvN9MNcj6CyWmWLFf9GT9NIi9i8rs8/Gv5kM33C3o6ynszH/MnfZUC9yNg5rGal3LSY13N3h+QyOUhoJtHUJtfV9JiQJBANIu2kto0L1s3mWGwHzGKAOTFYqyrhycqt+xddcQNYqiZdpBcJ+nmEHkBvhgcG7YDk9qAyalfVcys2Kh7gCHaA8CQQC0kKf/wpFqar3+NsK9NMuIEglWzuhZwODi17y6Fge/qzhTQz7l6lu3hJ2tQRDwqm1H8UYYp/lWBct/THIO2vndAkBSAVnGhlS7M5jp/9NmW2INUvvaq7BnFXFN6c1SZc6eEpKuv02T3S34t2FI00fK151tuq0UDQmEVhHLb+aOakZdAkEAoYhLksV4G5B0eah5nJRPhGJGUo91U132kVjYsEynD/PXxr0A1uRKuql7+ZOc2QBOFS8mO0aCC0/R1gcIfnutTQJAQEQ7pUaQc/P2LRzYJ16edmvz+Gj4WPxtMx/3xMOB3F3asekRu0Z092o70eI7Q8Kj4EEk5MmrufOY0vRazag/eQ==")
      .platformPublicKey("")
      .build();

  String BIZ_APP_KEY = "XM_CASHIER";


  @PostMapping(value = "/private/test/getWxOpenId")
  public JsonResult<String> getWxOpenId() {
    CashClient client = new CashClient(CONFIG);
    GetWxOpenIdRequest request = new GetWxOpenIdRequest();
    GetOpenIdModel model = GetOpenIdModel.builder()
        .appId("afsgdhj")
        .code("2345436457")
        .build();
    model.setAppKey(BIZ_APP_KEY);
    request.setBizModel(model);
    GetWxOpenIdResponse response = client.execute(request);
    log.info("getWxOpenId response {}", JSON.toJSONString(response));
    return JsonResult.success(response.getResult());
  }

  private String getSuffix(String url) {
    String[] split = url.split("\\?");
    String fileName = StringUtils.substringAfterLast(split[0], "/");
    String[] names = fileName.split("\\.");
    return "." + names[names.length - 1];
  }

}
