/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * <p>
 * 场馆先享后付订购单扣款记录
 * </p>
 *
 * @author chengyubing, created on 2024-11-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
public class StudioAxfOrderDeduction implements Serializable {

  private static final long serialVersionUID = -166947593419927514L;

  /**
   * 备注: 主键 是否允许为null: NO
   */
  @TableId(value = "id", type = IdType.ID_WORKER)
  private Long id;

  /**
   * 备注: 订购单ID 是否允许为null: YES
   */
  private Long orderId;

  /**
   * 备注: 扣款期数 是否允许为null: YES
   */
  private Integer period;

  /**
   * 备注: 扣款金额：元 是否允许为null: YES
   */
  private BigDecimal amount;

  /**
   * 备注: 实收金额（元） 是否允许为null: YES
   */
  private BigDecimal actualAmount;

  /**
   * 备注: 手续费 默认值: 0.00 是否允许为null: YES
   */
  private BigDecimal fee;

  /**
   * 备注: 费率(%) 是否允许为null: YES
   */
  private BigDecimal rate;

  /**
   * 备注: 扣款状态 是否允许为null: YES
   */
  private String state;

  /**
   * 备注: 扣款失败原因 是否允许为null: YES
   */
  private String failMessage;

  /**
   * 备注: 支付流水号 是否允许为null: YES
   */
  private String transNo;

  /**
   * 备注: 支付宝订购单号：冗余字段 是否允许为null: YES
   */
  private String thirdOrderNo;

  /**
   * 备注: 支付宝交易单号 是否允许为null: YES
   */
  private String thirdTransNo;

  /**
   * 备注: 追缴次数 默认值: 0 是否允许为null: YES
   */
  private Integer recoveryTimes;

  /**
   * 备注: 扣款时间 是否允许为null: YES
   */
  private Date deductionTime;

  /**
   * 备注: 创建时间 是否允许为null: YES
   */
  private Date createTime;

  /**
   * 备注: 更新时间 是否允许为null: YES
   */
  private Date updateTime;


  public static final String ID = "id";

  public static final String ORDER_ID = "order_id";

  public static final String PERIOD = "period";

  public static final String AMOUNT = "amount";

  public static final String ACTUAL_AMOUNT = "actual_amount";

  public static final String FEE = "fee";

  public static final String RATE = "rate";

  public static final String STATE = "state";

  public static final String FAIL_MESSAGE = "fail_message";

  public static final String TRANS_NO = "trans_no";

  public static final String THIRD_ORDER_NO = "third_order_no";

  public static final String THIRD_TRANS_NO = "third_trans_no";

  public static final String RECOVERY_TIMES = "recovery_times";

  public static final String DEDUCTION_TIME = "deduction_time";

  public static final String CREATE_TIME = "create_time";

  public static final String UPDATE_TIME = "update_time";

}
