package com.jiejing.fitness.finance.api.axf;

import com.jiejing.common.enums.ConfirmEnum;
import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.axf.request.CancelStudioAxfOrderRequest;
import com.jiejing.fitness.finance.api.axf.request.GetStudioAxfOrderByVoucherIdRequest;
import com.jiejing.fitness.finance.api.axf.request.GetStudioAxfOrderRequest;
import com.jiejing.fitness.finance.api.axf.request.ListStudioAxfOrderByVoucherIdsRequest;
import com.jiejing.fitness.finance.api.axf.request.ListStudioAxfOrderDeductionRequest;
import com.jiejing.fitness.finance.api.axf.request.ListStudioAxfOrderRecoveryRequest;
import com.jiejing.fitness.finance.api.axf.request.PageStudioAxfOrderRequest;
import com.jiejing.fitness.finance.api.axf.vo.AggStudioAxfOrderVO;
import com.jiejing.fitness.finance.api.axf.vo.StudioAxfOrderDeductionVO;
import com.jiejing.fitness.finance.api.axf.vo.StudioAxfOrderRecoveryVO;
import com.jiejing.fitness.finance.api.axf.vo.StudioAxfOrderVO;
import com.jiejing.paycenter.common.model.vo.CancelCommodityOrderVO;
import feign.hystrix.FallbackFactory;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 安心付订单API
 *
 * @author chengyubing
 * @since 2024/9/7 11:00
 */
@Component
public class StudioAxfOrderApiFallback implements FallbackFactory<StudioAxfOrderApi> {

  @Override
  public StudioAxfOrderApi create(Throwable throwable) {
    return new StudioAxfOrderApi() {
      @Override
      public JsonResult<CancelCommodityOrderVO> cancel(CancelStudioAxfOrderRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<PageVO<StudioAxfOrderVO>> page(PageStudioAxfOrderRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<AggStudioAxfOrderVO> agg(PageStudioAxfOrderRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<StudioAxfOrderVO> getById(GetStudioAxfOrderRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<StudioAxfOrderVO> getByVoucherId(GetStudioAxfOrderByVoucherIdRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<List<StudioAxfOrderVO>> listByVoucherIds(ListStudioAxfOrderByVoucherIdsRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<List<StudioAxfOrderDeductionVO>> listDeduction(
          ListStudioAxfOrderDeductionRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<ConfirmEnum> existFailDeduction(ListStudioAxfOrderDeductionRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<List<StudioAxfOrderRecoveryVO>> listRecovery(ListStudioAxfOrderRecoveryRequest request) {
        return JsonResult.rpcError();
      }
    };
  }
}
