package com.jiejing.fitness.finance.api.axf.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/9/5 15:17
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "查看最新一条安心付申请记录请求参数")
public class GetLatestAxfApplyRequest {

  @ApiModelProperty(value = "场馆ID", required = true)
  @NotNull(message = "场馆ID不能为空")
  private Long studioId;

  @ApiModelProperty(value = "merchantNo")
  private String merchantNo;

}
