
package com.jiejing.fitness.finance.api.axf.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/9/12 15:31
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "统计订购单VO")
public class AggStudioAxfOrderVO {

  @ApiModelProperty(value = "场馆ID")
  private Long studioId;

  @ApiModelProperty(value = "已扣款金额")
  private BigDecimal receivedAmount;

  @ApiModelProperty(value = "已扣款实收金额")
  private BigDecimal receivedActualAmount;

  @ApiModelProperty(value = "签约总金额（原价）")
  private BigDecimal originalPrice;

  @ApiModelProperty(value = "签约总金额（售价）")
  private BigDecimal salePrice;

  @ApiModelProperty(value = "费率")
  private BigDecimal rate;

}
