package com.jiejing.fitness.finance.api.axf.vo;

import com.jiejing.paycenter.common.enums.merchant.CommodityOrderDeductionStateEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * <p>
 * 场馆先学后付订购单扣款记录
 * </p>
 *
 * @author raccoon
 * @since 2024-09-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "场馆先学后付订购单扣款记录")
public class StudioAxfOrderDeductionVO {

  @ApiModelProperty(value = "主键")
  private Long id;

  @ApiModelProperty(value = "订购单ID")
  private Long orderId;

  @ApiModelProperty(value = "扣款期数")
  private Integer period;

  @ApiModelProperty(value = "扣款金额：元")
  private BigDecimal amount;

  @ApiModelProperty(value = "实收金额：元")
  private BigDecimal actualAmount;

  @ApiModelProperty(value = "费率（%）")
  private BigDecimal rate;

  @ApiModelProperty(value = "手续费：元")
  private BigDecimal fee;

  @ApiModelProperty(value = "扣款状态")
  private String state;

  @ApiModelProperty(value = "扣款失败原因")
  private String failMessage;

  @ApiModelProperty(value = "支付流水号")
  private String transNo;

  @ApiModelProperty(value = "支付宝订购单号")
  private String thirdOrderNo;

  @ApiModelProperty(value = "支付宝交易单号")
  private String thirdTransNo;

  @ApiModelProperty(value = "追缴次数")
  private Integer recoveryTimes;

  @ApiModelProperty(value = "扣款时间")
  private Date deductionTime;

  @ApiModelProperty(value = "创建时间")
  private Date createTime;

  @ApiModelProperty(value = "更新时间")
  private Date updateTime;


}
