package com.jiejing.fitness.finance.service.enums;

import com.jiejing.fitness.enums.finance.PartyTypeEnum;
import java.util.Arrays;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author chengyubing
 * @since 2024/9/7 14:23
 */
@Getter
@AllArgsConstructor
public enum MerchantBizCodeEnums {

  /**
   * bizcode
   */
  AXF("先学后付"),
  STUDIO("场馆"),
  BRAND("品牌"),
  UNKNOWN("未知"),

  ;
  private final String code = name();

  private final String message;

  public static MerchantBizCodeEnums getByCode(String code) {
    return Arrays.stream(MerchantBizCodeEnums.values()).filter(e -> e.getCode().equals(code)).findFirst()
        .orElse(UNKNOWN);
  }

}
