package com.jiejing.fitness.finance.service.rpc;

import com.google.common.collect.Sets;
import com.jiejing.common.model.JsonResult;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.jiejing.fos.api.vo.ResourceInfoVO;

import com.jiejing.common.utils.collection.CollectionUtil;
import com.jiejing.fitness.enums.tenant.TenantTypeEnum;
import com.jiejing.fos.FosRpcService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * @author chengyubing
 * @since 2024/1/25 18:05
 */
@Service
@RequiredArgsConstructor
public class ResourceRpcService {

  private final FosRpcService fosRpcService;


  public Map<Long, String> getResourceUrlMap(Long brandId, Collection<Long> resourceIds) {
    if (CollectionUtil.isEmpty(resourceIds)) {
      return Collections.emptyMap();
    }
    return fosRpcService.fetchTenantResources(TenantTypeEnum.BRAND.buildKey(brandId),
            Sets.newHashSet(resourceIds)).stream()
        .collect(Collectors.toMap(ResourceInfoVO::getResourceId, ResourceInfoVO::getUrl));
  }

  public Map<Long, ResourceInfoVO> getResourceMap(Long brandId, List<Long> resourceIds) {
    if (CollectionUtil.isEmpty(resourceIds)) {
      return Collections.emptyMap();
    }
    return fosRpcService.fetchTenantResources(TenantTypeEnum.BRAND.buildKey(brandId),
            Sets.newHashSet(resourceIds)).stream()
        .collect(Collectors.toMap(ResourceInfoVO::getResourceId, Function.identity()));
  }

}
