package com.jiejing.fitness.finance.api.merchant.vo;

import com.jiejing.common.swagger.EnumMapping;
import com.jiejing.fitness.enums.finance.EmbededXcxEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * <p>
 * 场馆半屏小程序申请记录
 * </p>
 *
 * @author chengyubing, created on 2024-08-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "半屏小程序VO")
public class StudioEmbeddedXcxVO {

  @ApiModelProperty("ID")
  private Long id;

  @ApiModelProperty("品牌ID")
  private Long brandId;

  @ApiModelProperty("场馆ID")
  private Long studioId;

  @ApiModelProperty("小程序appId")
  private String appId;

  @ApiModelProperty("授权方appId")
  private String authorizerAppId;

  @EnumMapping(enumClass = EmbededXcxEnum.class)
  @ApiModelProperty("状态")
  private String state;

  @ApiModelProperty("失败原因")
  private String message;

  @ApiModelProperty("创建时间")
  private Date createTime;

  @ApiModelProperty("更新时间")
  private Date updateTime;


}
