package com.jiejing.fitness.finance.api.cashier.vo;

import com.alibaba.fastjson.JSONObject;
import com.jiejing.common.swagger.EnumMapping;
import com.jiejing.fitness.enums.finance.BrandCashierTransStateEnum;
import com.jiejing.fitness.enums.finance.BrandCashierTransTypeEnum;
import com.jiejing.paycenter.common.enums.common.OpenStateEnums;
import com.jiejing.paycenter.common.enums.merchant.SubChannelEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/29 10:43
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "场馆收银流水VO")
public class StudioCashierRecordVO {

  @ApiModelProperty("主键")
  private Long id;

  @ApiModelProperty("交易流水号")
  private String transNo;

  @ApiModelProperty("业务订单ID")
  private String orderNo;

  @ApiModelProperty("业务订单号")
  private String businessNo;

  @ApiModelProperty("业务子订单号")
  private String subOrderNo;

  @ApiModelProperty("业务订单类型")
  private String orderType;

  @EnumMapping(enumClass = BrandCashierTransTypeEnum.class)
  @ApiModelProperty("交易类型：PAY-收款；REFUND-退款；")
  private String transType;

  @ApiModelProperty("品牌ID")
  private Long brandId;

  @ApiModelProperty("场馆ID")
  private Long studioId;

  @ApiModelProperty(value = "场馆名称")
  private String studioName;

  @ApiModelProperty("商户ID")
  private Long merchantId;

  @ApiModelProperty("商户号")
  private String merchantNo;

  @ApiModelProperty("渠道号")
  private String channelNo;

  @EnumMapping(enumClass = SubChannelEnums.class)
  @ApiModelProperty("支付子渠道：ALI-支付宝、WX-微信")
  private String subChannel;

  @ApiModelProperty("交易金额（元）")
  private BigDecimal transAmount;

  @ApiModelProperty("交易手续费率（%）")
  private BigDecimal feeRate;

  @ApiModelProperty("交易手续费")
  private BigDecimal fee;

  @ApiModelProperty("实际金额（元）")
  private BigDecimal actualAmount;

  @EnumMapping(enumClass = BrandCashierTransStateEnum.class)
  @ApiModelProperty("交易状态")
  private String transState;

  @ApiModelProperty("付款人姓名")
  private String buyerName;

  @ApiModelProperty("付款人手机号")
  private String buyerPhone;

  @ApiModelProperty("商品名称")
  private String goods;

  @ApiModelProperty("备注")
  private String remark;

  @ApiModelProperty("是否存在关联交易")
  private Boolean existRelatedTrans;

  @ApiModelProperty("关联的交易单号")
  private String relatedTransNo;

  @ApiModelProperty("三方交易单号")
  private String thirdTransNo;

  @ApiModelProperty("错误信息")
  private String failMessage;

  @ApiModelProperty("扩展信息")
  private JSONObject extra;

  @ApiModelProperty("交易发生时间")
  private Date tradingTime;

  @ApiModelProperty("交易成功时间")
  private Date successTime;

  @ApiModelProperty("入账时间")
  private Date inTime;

  @ApiModelProperty("创建时间")
  private Date createTime;

  @ApiModelProperty("更新时间")
  private Date updateTime;

}
