package com.jiejing.fitness.finance.service.event;

import static org.springframework.integration.IntegrationMessageHeaderAccessor.DELIVERY_ATTEMPT;

import com.alibaba.fastjson.JSON;
import com.jiejing.fitness.enums.finance.PartyTypeEnum;
import com.jiejing.fitness.finance.service.merchant.StudioMerchantService;
import com.jiejing.fitness.finance.service.pay.PayService;
import com.jiejing.paycenter.common.event.MerchantEvent;
import com.jiejing.paycenter.common.event.PayEvent;
import com.jiejing.paycenter.common.event.RefundEvent;
import com.xiaomai.event.annotation.EventHandler;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Service;

/**
 * @author chengyubing
 * @since 2024/2/21 14:30
 */
@Slf4j
@Service
public class ListenerService {

  private static final int MAX_RETRY = 3;

  @Resource
  private StudioMerchantService studioMerchantService;

  @Resource
  private PayService payService;


  @EventHandler(value = MerchantEvent.class, binder = "biz-kafka", maxAttempts = MAX_RETRY)
  public void handleMerchantEvent(MerchantEvent event, @Header(DELIVERY_ATTEMPT) int retryNum) {
    try {
      log.info("start process merchant event {}", JSON.toJSONString(event));
      event.setSubChannels(Optional.ofNullable(event.getSubChannels()).orElse(new ArrayList<>(1)));
      event.setSubChannelAuths(Optional.ofNullable(event.getSubChannelAuths()).orElse(new ArrayList<>(1)));

      PartyTypeEnum type = PartyTypeEnum.getByCode(event.getBizCode());
      switch (type) {
        case STUDIO:
          studioMerchantService.callback(event);
          break;
        default:
          break;
      }
    } catch (Exception e) {
      log.error("merchant event callback process fail {}", JSON.toJSONString(event), e);
    }
  }


  @EventHandler(value = PayEvent.class, binder = "biz-kafka", maxAttempts = MAX_RETRY)
  public void payEventCallback(PayEvent event, @Header(DELIVERY_ATTEMPT) int retryNum) {
    try {
      log.info("start process pay event {}", JSON.toJSONString(event));
      payService.payCallback(event);
    } catch (Exception e) {
      log.info("process pay event fail {}", event.getTransNo(), e);
    }
  }

  @EventHandler(value = RefundEvent.class, binder = "biz-kafka", maxAttempts = MAX_RETRY)
  public void refundEventCallback(RefundEvent event, @Header(DELIVERY_ATTEMPT) int retryNum) {
    try {
      log.info("start process refund event {}", JSON.toJSONString(event));
      payService.refundCallback(event);
    } catch (Exception e) {
      log.info("process refund event fail {}", event.getTransNo(), e);
    }
  }

}
