package com.jiejing.fitness.finance.api.cashier.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/29 10:57
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "品牌收银流水根据订单号查询关联收银流水Request")
public class ListBrandCashierByOrderNoRequest {

  @ApiModelProperty(value = "订单号", required = true)
  @NotBlank(message = "订单号不能为空")
  private String orderNo;

}
